<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Articulo extends Model 
{

    protected $table = 'articulo';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function articulo_destino()
    {
        return $this->hasMany('App\Models\ArticuloDestino');
    }

    public function tipo()
    {
        return $this->belongsTo('App\Models\TipoArticulo');
    }

}